function visitorData (json) {
	var data = jQuery.parseJSON(json);
	var seriesData = [];
	var xCategories = [];
	$.each(data, function (idx, obj) {
		$.each(this, function(key, val){
			xCategories[xCategories.length] = key;
			seriesData[seriesData.length] = parseInt(val);
			
		})
	})
	console.log(seriesData);
	
  Highcharts.chart('container', {
    chart: {
        type: 'column'
    },
    title: {
        text: 'Monthly Sales'
    },
    xAxis: {
        categories:  xCategories,
        crosshair: true
    },
    yAxis: {
        min: 0,
        title: {
            text: 'Sales Range'
        }
    },
    tooltip: {
        headerFormat: '<span style="font-size:10px">{point.key}</span><table>',
        pointFormat: '<tr><td style="color:{series.color};padding:0">{series.name}: </td>' +
            '<td style="padding:0"> <i class="fa fa-inr"> </i><b>{point.y:.2f}</b></td></tr>',
        footerFormat: '</table>',
        shared: true,
        useHTML: true
    },
    plotOptions: {
        column: {
            pointPadding: 0.2,
            borderWidth: 0
        }
    },
    series: [{
        name: 'Sales',
        data: seriesData

    }]
});
}
$(document).ready(function() {
 $.ajax({
    url: 'month_wise_chart.php',
    type: 'post',
    dataType: "text",
    success: function (json) {
        visitorData(json);
    }
  });
 });