function onDailySales() {
	
	var date1 = document.getElementById('date1').value;
	var date2 = document.getElementById('date2').value;
	var outlet = document.getElementById('outlet').value;
	var order = document.getElementById('order').value;
	
	var xmlhttp;
	if (window.XMLHttpRequest)
	{
		xmlhttp = new XMLHttpRequest();
	}
	else
	{
		xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
	}
	xmlhttp.onreadystatechange = function()
	{
		if (xmlhttp.readyState==4 && xmlhttp.status==200) //Success
		{
			var objResponse = JSON.parse(xmlhttp.responseText); //JSON.parse Parses a string as JSON
			console.log(objResponse);
			$("#daily-sales").jsGrid({
				width: "100%",
				height: "400px",
		 
				inserting: false,
				editing: false,
				sorting: true,
				paging: true,
		 
				data: objResponse,
		 
				fields: [
					{ name: "UnitName", width: 100 },
					{ name: "InvoiceNumber", width: 100 },
					{ name: "Date", width: 100 },
					{ name: "Time", width: 100 },
					{ name: "Description", width: 100 },
					{ name: "Quantity", width: 100 },
					{ name: "Price", width: 100 },
					{ name: "GrossTotal", width: 100 },
					{ name: "DiscountPercent", width: 100 },
					{ name: "DiscountAmount", width: 100 },
					{ name: "NetTotal", width: 100 },
					{ name: "SGSTPercent", width: 100 },
					{ name: "SGSTAmount", width: 100 },
					{ name: "CGSTPercent", width: 100 },
					{ name: "CGSTAmount", width: 100 },
					{ name: "CESSPercent", width: 100 },
					{ name: "CESSAmount", width: 100 },
					{ name: "BillTotal", width: 100 },
					{ name: "CashSale", width: 100 },
					{ name: "CardSale", width: 100 },
					{ name: "Voucher", width: 100 },
					{ name: "WalletCollection", width: 100 },
					{ name: "Credit", width: 100 },
					{ name: "OnliePayment", width: 100 },
					{ name: "Cashier", width: 100 },
					{ name: "OrderType", width: 100 },
					{ name: "OrderSource", width: 100 },
					{ name: "CCAgentName", width: 100 },
					{ name: "PaymentMode", width: 100 }
				]
			});
			
			var $btnDLtoExcel = $('#dailytoExcel');
			$btnDLtoExcel.on('click', function () {
				$("#exldailysales").excelexportjs({
					containerid: "exldailysales",
					datatype: 'json',
					dataset: objResponse,
					columns: getColumns(objResponse)     
				});
			});
		}
	};
	xmlhttp.open("GET","http://localhost/codeigniter/index.php/project_master/daily_sales_report?fd="+date1+"&td="+date2+"&ol="+outlet+"&od="+order,true);
	xmlhttp.send();
	
}

function onSalesSummery() {
	
	var date1 = document.getElementById('date1').value;
	var date2 = document.getElementById('date2').value;
	var outlet = document.getElementById('outlet').value;
	
	var xmlhttp;
	if (window.XMLHttpRequest)
	{
		xmlhttp = new XMLHttpRequest();
	}
	else
	{
		xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
	}
	xmlhttp.onreadystatechange = function()
	{
		if (xmlhttp.readyState==4 && xmlhttp.status==200) //Success
		{
			var objResponse = JSON.parse(xmlhttp.responseText); //JSON.parse Parses a string as JSON
			console.log(objResponse);
			
			$("#sales").jsGrid({
				width: "100%",
				height: "400px",
		 
				inserting: false,
				editing: false,
				sorting: true,
				paging: true,
		 
				data: objResponse,
		 
				fields: [
					{ name: "Date", width: 100 },
					{ name: "totalinvoice", width: 100 },
					{ name: "gross_sale", width: 100 },
					{ name: "discount", width: 100 },
					{ name: "offer_discount", width: 100 },
					{ name: "net_total_exc_vat", width: 100 },
					{ name: "ser_charge_amt", width: 100 },
					{ name: "SGSTamt", width: 100 },
					{ name: "CGSTAmt", width: 100 },
					{ name: "CESSamt", width: 100 },
					{ name: "rounding_amt", width: 100 },
					{ name: "TotalAmtinc_vat", width: 100 },
					{ name: "CashAmt", width: 100 },
					{ name: "CardAmt", width: 100 },
					{ name: "VoucherAmt", width: 100 },
					{ name: "CreditAmt", width: 100 },
					{ name: "OnlinePayment", width: 100 },
					{ name: "WalletAmt", width: 100 }
				]
			});
			
			var $btnDLtoExcel = $('#DLtoExcel');
			$btnDLtoExcel.on('click', function () {
				$("#exljson").excelexportjs({
					containerid: "exljson",
					datatype: 'json',
					dataset: objResponse,
					columns: getColumns(objResponse)     
				});
			});
			
			var date = [];
            var TotalAmt = [];
			for(var i in objResponse) {
                date.push(objResponse[i].Date);
                TotalAmt.push(parseInt(objResponse[i].TotalAmtinc_vat));
            }
			
			Highcharts.chart('chartContainer', {
				chart: {
					type: 'column'
				},
				title: {
					text: 'Sales summary report chart'
				},
				xAxis: {
					categories: date,
					crosshair: true
				},
				yAxis: {
					title: {
						text: 'Total Amount'
					}
				},
				tooltip: {
					headerFormat: '<span style="font-size:10px">{point.key}</span><table>',
					pointFormat: '<tr><td style="color:{series.color};padding:0">{series.name}: </td>' +
						'<td style="padding:0"><b>{point.y:.1f}</b></td></tr>',
					footerFormat: '</table>',
					shared: true,
					useHTML: true
				},
				exporting: {
					enabled: true
				},
				plotOptions: {
					column: {
						pointPadding: 0.2,
						borderWidth: 0
					}
				},
				series: [{
					name: 'total amount',
					data: TotalAmt
				}]
			});
		}
	};
	xmlhttp.open("GET","http://localhost/codeigniter/index.php/project_master/monthly_sales?fd="+date1+"&td="+date2+"&ot="+outlet,true);
	xmlhttp.send();
	
}

function onSkuDayWise() {
	
	var date1 = document.getElementById('date1').value;
	var date2 = document.getElementById('date2').value;
	var outlet = document.getElementById('outlet').value;
	var cuisine = document.getElementById('CuisineType').value;
	
	var xmlhttp;
	if (window.XMLHttpRequest)
	{
		xmlhttp = new XMLHttpRequest();
	}
	else
	{
		xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
	}
	xmlhttp.onreadystatechange = function()
	{
		if (xmlhttp.readyState==4 && xmlhttp.status==200) //Success
		{
			var objResponse = JSON.parse(xmlhttp.responseText); //JSON.parse Parses a string as JSON
			console.log(objResponse);
			$("#jsGrid").jsGrid({
				width: "100%",
				height: "400px",
		 
				inserting: false,
				editing: false,
				sorting: true,
				paging: true,
		 
				data: objResponse,
		 
				fields: [
					{ name: "GroupName", width: 100 },
					{ name: "ItemName", width: 100 },
					{ name: "quantity", width: 100 },
					{ name: "amount", width: 100 },
					{ name: "percent", width: 100 },
					{ name: "date", width: 100 }
				]
			});
			
			var $btnDLtoExcel = $('#SkuDaytoExcel');
			$btnDLtoExcel.on('click', function () {
				$("#exlskuday").excelexportjs({
					containerid: "exlskuday",
					datatype: 'json',
					dataset: objResponse,
					columns: getColumns(objResponse)     
				});
			});
			
			var GroupName = [];
            var TotalAmt = [];
			for(var i in objResponse) {
                GroupName.push(objResponse[i].GroupName);
                TotalAmt.push(parseInt(objResponse[i].amount));
            }
			
			Highcharts.chart('skuday', {
				chart: {
					type: 'column'
				},
				title: {
					text: 'SKU Day Wise chart'
				},
				xAxis: {
					categories: GroupName,
					crosshair: true
				},
				yAxis: {
					title: {
						text: 'Amount'
					}
				},
				tooltip: {
					headerFormat: '<span style="font-size:10px">{point.key}</span><table>',
					pointFormat: '<tr><td style="color:{series.color};padding:0">{series.name}: </td>' +
						'<td style="padding:0"><b>{point.y:.1f}</b></td></tr>',
					footerFormat: '</table>',
					shared: true,
					useHTML: true
				},
				exporting: {
					enabled: true
				},
				plotOptions: {
					column: {
						pointPadding: 0.2,
						borderWidth: 0
					}
				},
				series: [{
					name: 'Amount',
					data: TotalAmt
				}]
			});
		}
	};
	xmlhttp.open("GET","http://localhost/codeigniter/index.php/project_master/sku_day_wise?fd="+date1+"&td="+date2+"&ot="+outlet+"&ct="+cuisine,true);
	xmlhttp.send();
	
}

function onSkuMonthWise() {
	var month = document.getElementById('month').value;
	var year = document.getElementById('year').value;
	var outlet = document.getElementById('outlet').value;
	
	var xmlhttp;
	if (window.XMLHttpRequest)
	{
		xmlhttp = new XMLHttpRequest();
	}
	else
	{
		xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
	}
	xmlhttp.onreadystatechange = function()
	{
		if (xmlhttp.readyState==4 && xmlhttp.status==200) //Success
		{
			var objResponse = JSON.parse(xmlhttp.responseText); //JSON.parse Parses a string as JSON
			console.log(objResponse);
			$("#skumonth").jsGrid({
				width: "100%",
				height: "400px",
		 
				inserting: false,
				editing: false,
				sorting: true,
				paging: true,
		 
				data: objResponse,
		 
				fields: [
					{ name: "GroupName", width: 100 },
					{ name: "ItemName", width: 100 },
					{ name: "quantity", width: 100 },
					{ name: "amount", width: 100 },
					{ name: "percent", width: 100 },
					{ name: "month", width: 100 }
				]
			});
			
			var $btnDLtoExcel = $('#SkuMonthtoExcel');
			$btnDLtoExcel.on('click', function () {
				$("#exlskumonth").excelexportjs({
					containerid: "exlskumonth",
					datatype: 'json',
					dataset: objResponse,
					columns: getColumns(objResponse)     
				});
			});
			
			var GroupName = [];
            var TotalAmt = [];
			for(var i in objResponse) {
                GroupName.push(objResponse[i].GroupName);
                TotalAmt.push(parseInt(objResponse[i].amount));
            }
			Highcharts.chart('skumonthchart', {
				chart: {
					type: 'column'
				},
				title: {
					text: 'SKU Month Wise chart'
				},
				xAxis: {
					categories: GroupName,
					crosshair: true
				},
				yAxis: {
					title: {
						text: 'Amount'
					}
				},
				tooltip: {
					headerFormat: '<span style="font-size:10px">{point.key}</span><table>',
					pointFormat: '<tr><td style="color:{series.color};padding:0">{series.name}: </td>' +
						'<td style="padding:0"><b>{point.y:.1f}</b></td></tr>',
					footerFormat: '</table>',
					shared: true,
					useHTML: true
				},
				exporting: {
					enabled: true
				},
				plotOptions: {
					column: {
						pointPadding: 0.2,
						borderWidth: 0
					}
				},
				series: [{
					name: 'Amount',
					data: TotalAmt
				}]
			});
		}
	};
	xmlhttp.open("GET","http://localhost/codeigniter/index.php/project_master/sku_month_wise?m="+month+"&y="+year+"&u="+outlet,true);
	xmlhttp.send();
	
}

function onChannelWise() {
	var date1 = document.getElementById('date1').value;
	var date2 = document.getElementById('date2').value;
	var outlet = document.getElementById('outlet').value;
	var order = document.getElementById('SourceOfOrder').value;
	var idrej = document.getElementById('IdRejected').value;
	
	var xmlhttp;
	if (window.XMLHttpRequest)
	{
		xmlhttp = new XMLHttpRequest();
	}
	else
	{
		xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
	}
	xmlhttp.onreadystatechange = function()
	{
		if (xmlhttp.readyState==4 && xmlhttp.status==200) //Success
		{
			var objResponse = JSON.parse(xmlhttp.responseText); //JSON.parse Parses a string as JSON
			console.log(objResponse);
			$("#channel-home").jsGrid({
				width: "100%",
				height: "400px",
		 
				inserting: false,
				editing: false,
				sorting: true,
				paging: true,
		 
				data: objResponse,
		 
				fields: [
					{ name: "order_no", width: 100 },
					{ name: "invoice_no", width: 100 },
					{ name: "orderdatetime", width: 100 },
					{ name: "customer_name", width: 100 },
					{ name: "mobile_no", width: 100 },
					{ name: "del_loc", width: 100 },
					{ name: "bill_amt", width: 100 },
					{ name: "payment_option", width: 100 },
					{ name: "punch_time", width: 100 },
					{ name: "in_store_dur", width: 100 },
					{ name: "dispatch_time", width: 100 },
					{ name: "complete_time", width: 100 },
					{ name: "order_status", width: 100 },
					{ name: "boy_name", width: 100 },
					{ name: "order_by", width: 100 },
					{ name: "order_source", width: 100 }
				]
			});
			
			var $btnDLtoExcel = $('#channelExcel');
			$btnDLtoExcel.on('click', function () {
				$("#exlchannel").excelexportjs({
					containerid: "exlchannel",
					datatype: 'json',
					dataset: objResponse,
					columns: getColumns(objResponse)     
				});
			});
			
			var order = [];
            var billamt = [];
			for(var i in objResponse) {
                order.push(objResponse[i].order_no);
                billamt.push(parseInt(objResponse[i].bill_amt));
            }
			Highcharts.chart('channelwise', {
				chart: {
					type: 'column'
				},
				title: {
					text: 'Channel Wise Delivery chart'
				},
				xAxis: {
					categories: order,
					crosshair: true
				},
				yAxis: {
					title: {
						text: 'Bill Amount'
					}
				},
				tooltip: {
					headerFormat: '<span style="font-size:10px">{point.key}</span><table>',
					pointFormat: '<tr><td style="color:{series.color};padding:0">{series.name}: </td>' +
						'<td style="padding:0"><b>{point.y:.1f}</b></td></tr>',
					footerFormat: '</table>',
					shared: true,
					useHTML: true
				},
				exporting: {
					enabled: true
				},
				plotOptions: {
					column: {
						pointPadding: 0.2,
						borderWidth: 0
					}
				},
				series: [{
					name: 'Bill Amount',
					data: billamt
				}]
			});
		}
	};
	xmlhttp.open("GET","http://localhost/codeigniter/index.php/project_master/channel_wise_home_delivery?fd="+date1+"&td="+date2+"&ol="+outlet+"&ord="+order+"&on="+idrej,true);
	xmlhttp.send();
	
}

function onAgentApc() {
	var date1 = document.getElementById('date1').value;
	var date2 = document.getElementById('date2').value;
	
	var xmlhttp;
	if (window.XMLHttpRequest)
	{
		xmlhttp = new XMLHttpRequest();
	}
	else
	{
		xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
	}
	xmlhttp.onreadystatechange = function()
	{
		if (xmlhttp.readyState==4 && xmlhttp.status==200) //Success
		{
			var objResponse = JSON.parse(xmlhttp.responseText); //JSON.parse Parses a string as JSON
			console.log(objResponse);
			$("#agent-apc").jsGrid({
				width: "100%",
				height: "400px",
		 
				inserting: false,
				editing: false,
				sorting: true,
				paging: true,
		 
				data: objResponse,
		 
				fields: [
					{ name: "agent", width: 100 },
					{ name: "apc", width: 100 },
					{ name: "orders", width: 100 },
					{ name: "value", width: 100 }
				]
			});
			
			var $btnDLtoExcel = $('#agentApcExcel');
			$btnDLtoExcel.on('click', function () {
				$("#exlagentapc").excelexportjs({
					containerid: "exlagentapc",
					datatype: 'json',
					dataset: objResponse,
					columns: getColumns(objResponse)     
				});
			});
			
			var agent = [];
			var apc = [];
			var orders = [];
            var value = [];
			for(var i in objResponse) {
                agent.push(objResponse[i].agent);
                apc.push(parseInt(objResponse[i].apc));
                orders.push(parseInt(objResponse[i].orders));
                value.push(parseInt(objResponse[i].value));
            }
			Highcharts.chart('agentwiseapc', {
				chart: {
					type: 'column'
				},
				title: {
					text: 'Agent Wise APC Chart'
				},
				xAxis: {
					categories: agent,
					crosshair: true
				},
				yAxis: {
					title: {
						text: 'Orders'
					}
				},
				tooltip: {
					headerFormat: '<span style="font-size:10px">{point.key}</span><table>',
					pointFormat: '<tr><td style="color:{series.color};padding:0">{series.name}: </td>' +
						'<td style="padding:0"><b>{point.y:.1f}</b></td></tr>',
					footerFormat: '</table>',
					shared: true,
					useHTML: true
				},
				exporting: {
					enabled: true
				},
				plotOptions: {
					column: {
						pointPadding: 0.2,
						borderWidth: 0
					}
				},
				series: [{
					name: 'APC',
					data: apc
				}, {
					name: 'Orders',
					data: orders
				}, {
					name: 'Value',
					data: value
				}]
			});
		}
	};
	xmlhttp.open("GET","http://localhost/codeigniter/index.php/project_master/agent_apc_report?fd="+date1+"&td="+date2,true);
	xmlhttp.send();
	
}

function onReconcileSale() {
	var date1 = document.getElementById('date1').value;
	var date2 = document.getElementById('date2').value;
	var outlet = document.getElementById('outlet').value;
	
	var xmlhttp;
	if (window.XMLHttpRequest)
	{
		xmlhttp = new XMLHttpRequest();
	}
	else
	{
		xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
	}
	xmlhttp.onreadystatechange = function()
	{
		if (xmlhttp.readyState==4 && xmlhttp.status==200) //Success
		{
			var objResponse = JSON.parse(xmlhttp.responseText); //JSON.parse Parses a string as JSON
			console.log(objResponse);
			$("#recon-sale").jsGrid({
				width: "100%",
				height: "150px",
		 
				inserting: false,
				editing: false,
				sorting: true,
				paging: true,
		 
				data: objResponse,
		 
				fields: [
					{ name: "No_of_Invoices", width: 100 },
					{ name: "Gross_Sales", width: 100 },
					{ name: "Discount", width: 100 },
					{ name: "Nett_Sales_Excluding_VAT", width: 100 },
					{ name: "Vat_Amount", width: 100 },
					{ name: "Service_Tax_Amount", width: 100 },
					{ name: "Service_Charge_Amount", width: 100 },
					{ name: "SGST_Amount", width: 100 },
					{ name: "CGST_Amount", width: 100 },
					{ name: "Total_Amount", width: 100 }
				]
			});
			
			$("#reconcile").jsGrid({
				width: "100%",
				height: "400px",
		 
				inserting: false,
				editing: false,
				sorting: true,
				paging: true,
		 
				data: objResponse,
		 
				fields: [
					{ name: "source", width: 100 },
					{ name: "mode", width: 100 },
					{ name: "Inv", width: 100 },
					{ name: "Amt", width: 100 }
				]
			});
			//document.getElementById("demo").innerHTML = objResponse.responseText;
		}
	};
	xmlhttp.open("GET","http://localhost/codeigniter/index.php/project_master/reconcile_sale_report?fd="+date1+"&td="+date2+"&ol="+outlet,true);
	xmlhttp.send();
	
}

function onApcReport() {
	var date1 = document.getElementById('date1').value;
	var date2 = document.getElementById('date2').value;
	
	var xmlhttp;
	if (window.XMLHttpRequest)
	{
		xmlhttp = new XMLHttpRequest();
	}
	else
	{
		xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
	}
	xmlhttp.onreadystatechange = function()
	{
		if (xmlhttp.readyState==4 && xmlhttp.status==200) //Success
		{
			var objResponse = JSON.parse(xmlhttp.responseText); //JSON.parse Parses a string as JSON
			console.log(objResponse);
			$("#apc-report").jsGrid({
				width: "100%",
				height: "400px",
		 
				inserting: false,
				editing: false,
				sorting: true,
				paging: true,
		 
				data: objResponse,
		 
				fields: [
					{ name: "agent", width: 100 },
					{ name: "apc", width: 100 },
					{ name: "orders", width: 100 },
					{ name: "value", width: 100 }
				]
			});
			//document.getElementById("demo").innerHTML = objResponse.responseText;
		}
	};
	xmlhttp.open("GET","http://localhost/codeigniter/index.php/project_master/apc_report?fd="+date1+"&td="+date2,true);
	xmlhttp.send();
	
}

function onLocalityOpt() {
	var date1 = document.getElementById('date1').value;
	var date2 = document.getElementById('date2').value;
	var outlet = document.getElementById('outlet').value;
	var loc = document.getElementById('localityhdid').checked;
	
	var xmlhttp;
	if (window.XMLHttpRequest)
	{
		xmlhttp = new XMLHttpRequest();
	}
	else
	{
		xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
	}
	xmlhttp.onreadystatechange = function()
	{
		if (xmlhttp.readyState==4 && xmlhttp.status==200) //Success
		{
			var objResponse = JSON.parse(xmlhttp.responseText); //JSON.parse Parses a string as JSON
			console.log(objResponse);
			$("#locality").jsGrid({
				width: "100%",
				height: "400px",
		 
				inserting: false,
				editing: false,
				sorting: true,
				paging: true,
		 
				data: objResponse,
		 
				fields: [
					{ name: "zone", width: 100 },
					{ name: "localityName", width: 100 },
					{ name: "No_of_household", width: 100 },
					{ name: "locality_status", width: 100 },
					{ name: "DH", width: 100 },
					{ name: "NPI", width: 100 },
					{ name: "Total", width: 100 },
					{ name: "HD_orders", width: 100 },
					{ name: "Flyer_conv", width: 100 },
					{ name: "penetration_percent", width: 100 },
					{ name: "new_guest", width: 100 },
					{ name: "Repeat_guest", width: 100 }
				]
			});
			//document.getElementById("demo").innerHTML = objResponse.responseText;
		}
	};
	xmlhttp.open("GET","http://localhost/codeigniter/index.php/project_master/locality_optimizer_home?fd="+date1+"&td="+date2+"&ol="+outlet+"&loc="+loc,true);
	xmlhttp.send();
	
}

function onManagDash() {
	var month = document.getElementById('month').value;
	var year = document.getElementById('year').value;
	
	var xmlhttp;
	if (window.XMLHttpRequest)
	{
		xmlhttp = new XMLHttpRequest();
	}
	else
	{
		xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
	}
	xmlhttp.onreadystatechange = function()
	{
		if (xmlhttp.readyState==4 && xmlhttp.status==200) //Success
		{
			var objResponse = JSON.parse(xmlhttp.responseText); //JSON.parse Parses a string as JSON
			console.log(objResponse);
			$("#management").jsGrid({
				width: "100%",
				height: "400px",
		 
				inserting: false,
				editing: false,
				sorting: true,
				paging: true,
		 
				data: objResponse,
		 
				/* fields: [
					{ name: "zone", width: 100 },
					{ name: "localityName", width: 100 },
					{ name: "No_of_household", width: 100 },
					{ name: "locality_status", width: 100 },
					{ name: "DH", width: 100 },
					{ name: "NPI", width: 100 },
					{ name: "Total", width: 100 },
					{ name: "HD_orders", width: 100 },
					{ name: "Flyer_conv", width: 100 },
					{ name: "penetration_percent", width: 100 },
					{ name: "new_guest", width: 100 },
					{ name: "Repeat_guest", width: 100 }
				] */
			});
			//document.getElementById("demo").innerHTML = objResponse.responseText;
		}
	};
	xmlhttp.open("GET","http://localhost/codeigniter/index.php/project_master/management_dashboard?mn="+month+"&yr="+year,true);
	xmlhttp.send();
	
}

function onOutletSalesGrid() {
	var month = document.getElementById('month').value;
	var year = document.getElementById('year').value;
	
	var xmlhttp;
	if (window.XMLHttpRequest)
	{
		xmlhttp = new XMLHttpRequest();
	}
	else
	{
		xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
	}
	xmlhttp.onreadystatechange = function()
	{
		if (xmlhttp.readyState==4 && xmlhttp.status==200) //Success
		{
			var objResponse = JSON.parse(xmlhttp.responseText); //JSON.parse Parses a string as JSON
			console.log(objResponse);
			$("#sales-grid").jsGrid({
				width: "100%",
				height: "400px",
		 
				inserting: false,
				editing: false,
				sorting: true,
				paging: true,
		 
				data: objResponse,
		 
				fields: [
					{ name: "unit_name", width: 150 },
					{ name: "total_day_sales", width: 150 },
					{ name: "monthly_total", width: 150 },
					{ name: "ASPD_current_month", width: 150 },
					{ name: "ASPD_previous_month", width: 150 },
					{ name: "growth_last_month", width: 150 },
					{ name: "Apr_Projected", width: 150 },
					{ name: "monthly_budget", width: 150 },
					{ name: "Achieve_Budget_percent", width: 150 }
				]
			});
			//document.getElementById("demo").innerHTML = objResponse.responseText;
		}
	};
	xmlhttp.open("GET","http://localhost/codeigniter/index.php/project_master/outlet_sales?mn="+month+"&yr="+year,true);
	xmlhttp.send();
	
}