// jquery script for daily, weekly and monthly for order insight
function orderInsightGraphData(type) {
	$.ajax({
		url: 'get_all_analysis_data.php?act='+type,
		success : function(data){
			console.log(data);
		}
	});
}

/*graph for order insight*/
function getOIGraphReportByDate(action, daterange) {
	$.ajax({
		url: 'get_all_analysis_data.php?act='+action+'&daterange='+daterange,
		success : function(data){
			console.log(data);
			var bns = JSON.parse(data);

			var newcustomer = bns.newcustomer;
			var repeatcustomer = bns.repeatcustomer;
			var TotalAmt = bns.TotalAmt;
			var date = bns.date;
			// var neworders = bns.neworders;
			var totalorders = bns.totalorders;
			// var repeatorders = bns.repeatorders;
			// console.log(neworders);
			// var neworders = [14, 27, 29, 29, 32, 56, 71, 48, 21, 24, 46, 34, 44, 71];

			$(".newcustomer").html(newcustomer);
			$(".repeat-visits").html(repeatcustomer);
			$(".amount-spent").html('<i class="fa fa-inr" aria-hidden="true"></i> '+TotalAmt);

			Highcharts.chart('graphOrderInsight', {
			    chart: {
			        type: 'area'
			    },
			    title: {
			        text: ''
			    },
			    subtitle: {
			        text: ''
			    },
			    xAxis: {
			        categories: date,
			        tickmarkPlacement: 'on',
			        title: {
			            enabled: true,
			            text: 'date'
			        }
			    },
			    yAxis: {
			    	min: 0,
			        title: {
			            text: 'Orders'
			        }
			    },
			    /*tooltip: {
			        pointFormat: '<span style="color:{series.color}">{series.name}</span>: <b>{point.percentage:.1f}%</b> ({point.y:,.0f} millions)<br/>',
			        split: true
			    },*/
			    plotOptions: {
			        area: {
			            // stacking: 'percent',
			            lineColor: '#ffffff',
			            lineWidth: 1,
			            marker: {
			                lineWidth: 1,
			                lineColor: '#ffffff'
			            }
			        }
			    },
			    series: [/*{
			        name: 'New Orders',
			        data: neworders
			    },*/ {
			        name: 'Total Orders',
			        data: totalorders
			    }/*, {
			        name: 'Repeat Orders',
			        data: repeatorders
			    }*/]
			});
		}
	});
}

/*order details of customer*/
function viewDetailsClientOrders(action, orderid, unitid, invoiceno, orderdate) {
	$("#viewOrderDetails").show();
	$.ajax({
		url: 'get_all_analysis_data.php?act='+action+'&orderid='+orderid+'&unitid='+unitid+'&invoiceno='+invoiceno+'&orderdate='+orderdate,
		success : function(data){
			console.log(data);
			var bns = JSON.parse(data);
			var orderDetail = bns.orderDetail;
			$(".orderDetail").html(orderDetail);
		}
	});
}

/*search order information by filter*/
function getOrderInformation(action, fin, outlet, orderid, invoiceno) {
	if (outlet == '' || fin == '') {
		alert("Please select outlet and financial year");
	}
	$.ajax({
		url: 'get_all_analysis_data.php?act='+action+'&fin='+fin+'&outlet='+outlet+'&orderid='+orderid+'&invoiceno='+invoiceno,
		success : function(data) {
			console.log(data);
			var bns = JSON.parse(data);
			$(".customername").val(bns.name);
			$(".customermobile").val(bns.mobile);
			$(".customerorderid").val(bns.orderid);
			$(".customerinvno").val(bns.invoicenum);
			$(".customerorderdate").val(bns.orderdate);
			$(".ordertotalbill").val(bns.ordertotalbill);
			$(".customerpaymentmode").val(bns.paymentmode);
			$(".customerorderstatus").val(bns.orderstatus);
			$(".custordersource").val(bns.ordersource);
			$(".outletname").val(bns.outlet);
			$(".localityname").val(bns.locality);
			if (bns.productname != '') {
				$(".product-name").html(bns.productname);
			} else {
				$(".product-name").html('<input type="text" name="" class="form-control mb-lg" value="">');
			}
			if (bns.quantity != '') {
				$(".product-quantity").html(bns.quantity);
			} else {
				$(".product-quantity").html('<input type="text" name="" class="form-control mb-lg pro-qnt" value="">');
			}
			// $(".product-name").html(bns.productname);
			// $(".product-quantity").html(bns.quantity);
		}
	});
}

/*graph for product insight*/
function getProinsGraphReportByDate(action, daterange) {
	$.ajax({
		url: 'get_all_analysis_data.php?act='+action+'&daterange='+daterange,
		success : function(data){
			// console.log(data);
			var bns = JSON.parse(data);

			var groupname = bns.groupname;
			var itemname = bns.itemname;
			// console.log(groupname);
			// console.log(itemname);
			var groupname1 = [];
			for (var i = 0; i < groupname.length; i++) {
                groupname1.push({
                    name: groupname[i].name,
                    y: parseInt(groupname[i].y),
                    drilldown: groupname[i].drilldown
                });
            }
            // console.log(groupname1);
            /*var itmname = [];
            var item = [];
            for (var k = 0; k < groupname.length; k++) {
            	// j= 0;
            	for (var j = 0; (j < itemname.length) && (itemname.groupname == groupname.name); j++) {
	                
	                	item.push({
	                		name: itemname[j].name,
	                        y: parseInt(itemname[j].y)
	                	});
	                    itmname.push({
	                        id: groupname[k].drilldown,
	                        name: groupname[k].drilldown,
	                        data: item
	                    });
	                    // j++;
	                
	            }
            }*/

			Highcharts.chart('productInsGraph', {
			    chart: {
			        type: 'column'
			    },
			    title: {
			        text: ''
			    },
			    subtitle: {
			        text: ''
			    },
			    xAxis: {
			        type: 'category'
			    },
			    yAxis: {
			        title: {
			            text: 'Values'
			        }

			    },
			    legend: {
			        enabled: false
			    },

			    plotOptions: {
			        series: {
			            borderWidth: 0,
			            dataLabels: {
			                enabled: true,
			            }
			        }
			    },

			    series: [{
			        name: 'Categories',
			        colorByPoint: true,
			        data: groupname1
			    }],
			    drilldown: {
			        series: itemname
			    }
			});
		}
	});
}


/*graph of customers for all channels*/
function getACIGraphReportByDate(action, daterange) {
	$.ajax({
		url: 'get_all_analysis_data.php?act='+action+'&daterange='+daterange,
		success : function(data) {
			console.log(data);
			var bns = JSON.parse(data);
			var sourceorder = bns.sourceorder;
			var newcustomer = bns.newcustomer;

			Highcharts.chart('channel-wise-orders', {
			    chart: {
			        type: 'column'
			    },
			    title: {
			        text: ''
			    },
			    subtitle: {
			        text: ''
			    },
			    xAxis: {
			    	categories: sourceorder,
			        type: 'category'
			    },
			    yAxis: {
			        title: {
			            text: 'Count'
			        }

			    },
			    legend: {
			        enabled: false
			    },
			    plotOptions: {
			        series: {
			            borderWidth: 0,
			            dataLabels: {
			                enabled: true,
			                format: ''
			            }
			        }
			    },

			    tooltip: {
			        headerFormat: '<span style="font-size:11px">{series.name}</span><br>',
			        pointFormat: '<span style="color:{point.color}">{point.name}</span>: <b>{point.y}</b><br/>'
			    },

			    series: [{
			        name: 'New Customers',
			        data: newcustomer
			    }]
			});
		}
	});
}