<?php
session_start();
if(!isset($_SESSION['user'])) {
	header("location: ../index.php");
	exit;
}

include "../dbconnect.php";
 
include"../header.php";
?>
<link href="../assets/css/analysis.css" rel="stylesheet">

						<div class="row">
							<div class="col-lg-12">

								<div class="card">
									<div class="card-header admin-feed">
										Product Insights
									</div>
									<div class="card-body">
										<div class="row">
											<div class="col-lg-12">

												<section style="min-height: 377px;">
												   	<div class="content-wrapper" style="overflow: initial;">
												     	<h4 class="mt-lg mb-lg heading-sub-menu">
												        	<span class="btn-group pull-right">
												          		<!-- <button type="button" class="btn text-md btn-menu dropdown-toggle pull-right js-range" data-toggle="dropdown" aria-expanded="false">March 16, 2018 to March 23, 2018<span class="caret"></span></button> -->
                                                                <input type="text" class="btn text-md btn-menu dropdown-toggle pull-right js-range" id="product-daterange" onchange="getProinsGraphReportByDate( 'proinsDate', document.getElementById('product-daterange').value )" >
												        	</span>
												        	<span class="text-xl">Product Insights</span>
												     	</h4>

												      	<ul class="nav nav-pills mb pl heading-border">
													         <!-- <li class="active ml"><a href="report/products-sold" class = "js-redirect-product-sold">Products Sold</a>
													         </li>
													         <li><a href="report/product-trends" class = "js-redirect-product-trends">Product Trends</a>
													         </li>
													         <li><a href="report/product-magic" class = "js-redirect-product-magic">Magic Quadrant</a>
													         </li> -->
												         	<li class="active ml">
												         		<a href="#products-sold" class="js-redirect-product-sold" data-toggle="tab">Products Sold</a>
												         	</li>
												         	<li>
												         		<a href="#products-trends" class="js-redirect-product-trends" data-toggle="tab">Product Trends</a>
												         	</li>
												         	<li>
												         		<a href="#products-magic" class="js-redirect-product-magic" data-toggle="tab">Magic Quadrant</a>
												         	</li>
												      	</ul>

												      	<div class="tab-content">
													    	<!-- start product sold tab -->
													      	<div id="products-sold" class="tab-pane fade in active tab-custom" role="tabpanel">
													      		<p class="text-lg mt-xl ml-lg insights">Track orders across product categories.</p>
							                                  	<blockquote class="text-md mt-xl js-product-recommendation" style="">Quick fact :  is among your top selling products in this period :)</blockquote>

								                                <div class="js-graph mt-xl ml-lg" style="">
								                                  	<div id="productInsGraph" style="width: 100%; height: 400px; margin: 0 auto; margin-top: 60px;">
								                                  	</div>
								                                </div>
								                              
								                                <div class="js-load mt-xl" align="center" style="display: none;">
								                                  	<div class="loader graph-load"></div>
								                                </div>
													      	</div>

													      	<!-- start product trends tab -->
													      	<div id="products-trends" class="tab-pane fade in tab-custom" role="tabpanel">
													      		<p class="text-lg ml-lg mt-xl">Hot 🔥 or Not? Track Product Trends.</p>
                                                              	<div class="row">
                                                                
                                                                	<div class="col-lg-3 col-md-4 col-sm-6 col-xs-12 ml-lg">
                                                                  		<span class="mb mt">Choose Product</span>
                                                                  		<br>
                                                                  		<select class="js-product-change" id="dropdown" tabindex="-1" aria-hidden="true">
                                                                            <option value="432600" selected="">Heydrabadi Biryani</option>
                                                                        </select>
                                                                	</div>

	                                                                <div class="ml-lg col-lg-3 col-md-4 col-sm-6 col-xs-12 ml-lg pull-right">
	                                                                  	<span class="mb mt">View Type</span>
	                                                                  	<br>
	                                                                    <div class="btn-group ">
	                                                                        <button type="button" class="btn btn-default js-graph-change js-report" id="daily">Daily</button>
	                                                                        <button type="button" class="btn btn-default js-graph-change js-report active" id="week" active="">Weekly</button>
	                                                                        <button type="button" class="btn btn-default js-graph-change js-report" id="month">Monthly</button>
	                                                                    </div>
	                                                                </div>
                                                              	</div>
                                                              
                                                              	<div class="js-graph mt-xl" style="">
                                                                	<div class="channelanalytics mt-xl" id="productTrends" style="width: 1200px; height: 400px; margin: 0 auto">
                                                                	</div>
                                                              	</div>

                                                              	<div class="js-load mt-xl" align="center" style="display: none;">
                                                                	<div class="loader graph-load"></div>
                                                              	</div>
	                                                            
													      	</div>

													      	<!-- start magic quadrant tab -->
													      	<div id="products-magic" class="tab-pane fade in tab-custom" role="tabpanel">
													      		<p class="text-lg ml-lg mt-lg">Filter the magic quadrant.</p>
														        <div role="form" class="form-inline ml-lg">
														          	<div class="form-group mr">
														             	<label for="input-level" class="sr-only">Select Level</label>
														             	<select class="form-control" id="js-change-category-level">
														                    <option value="8641" selected="">Biryani</option>
														                    <option value="0" selected="">All Categories</option>
															               	<!-- <option value="1" selected>Categories</option>
															               	<option value="0" >Products</option>
															               	<option value="2" >Sub-Categories</option> -->
														             	</select>
														          	</div>
														          	<div class="form-group mr">
														            	<label for="input-location" class="sr-only">Choose Locations</label>
														            	<select class="form-control" id="js-location">
														               		<option class="js-change-location" value="0" selected="">All Locations</option>
														                    <option class="js-change-location" value="4803">Saket</option>
														                </select>
														          	</div>
														          	<button type="button" class="btn btn-info js-export-data">Export Data</button>
														       	</div>
														        <br><br>
														        <div class="row">
														         	<div class="col-xs-12">
														           		<div class="graphbox mt-xl">
														           			<div class="js-graph-no-data" style="display: none">No data found for this category :(</div>
															             	<div class="js-graph" style="">
																               	<div class="magicquadrant mt-lg hidden-xs" id="magquadrant" style="width: 1200px; height: 400px; margin: 0 auto">
																               	</div>
																               	<div class="magicquadrant mt-lg visible-xs"></div>
																            </div>
														           		</div>
														         	</div>
														       	</div>
														        <div class="js-load" align="center" style="display: none;">
														           	<div class="loader-report">
														           	</div>
														       </div>
													      	</div>

													    </div>

												   	</div>
												</section>

											</div>
										</div>
									</div>
								</div>
							</div>
						</div>

<?php
include"../footer.php";
?>


<script type="text/javascript">


// Create the chart
/*$('#container').highcharts({
    chart: {
        type: 'column'
    },
    title: {
        text: ''
    },
    subtitle: {
        text: ''
    },
    xAxis: {
        type: 'category'
    },
    yAxis: {
        title: {
            text: 'Values'
        }

    },
    legend: {
        enabled: false
    },

    plotOptions: {
        series: {
            borderWidth: 0,
            dataLabels: {
                enabled: true,
            }
        }
    },

    series: [{
        name: 'Categories',
        colorByPoint: true,
        data: [{
            name: 'Non-Veg Biryani',
            y: 6,
            drilldown: 'nonvegbiryani'
        }, {
            name: 'Veg Biryani',
            y: 4,
            drilldown: 'vegbiryani'
        }, {
            name: 'Dessert',
            y: 9,
            drilldown: 'dessert'
        }]
    }],
    drilldown: {
        series: [{
            id: 'nonvegbiryani',
            name: 'Sub-Categories',
            data: [{
                name: 'Hyderabadi',
                y: 4,
                drilldown: 'hyderabadi'
            }, ['Lucknowi', 2],
                ['Korma', 1],
                ['Kebab', 2],
                ['Murg', 1]
            ]
        }, {
            id: 'vegbiryani',
            name: 'Sub-Categories',
            data: [{
                name: 'Paneer',
                y: 4,
                drilldown: 'paneer'
            }, ['Mushroom', 2],
                ['Potato', 1],
                ['Gobhi', 2]
            ]
        }, {
            id: 'dessert',
            name: 'Sub-Categories',
            data: [{
                name: 'Rasgolla',
                y: 4,
                drilldown: 'rasgolla'
            }, ['Gulab Jamun', 2],
                ['Rabri', 1],
                ['Barfi', 2]
            ]
        }, {
        	id: 'hyderabadi',
            data: [ 
            	['Hyderabadi1', 5],
            	['Hyderabadi2', 2],
            	['Hyderabadi3', 1],
            	['Hyderabadi4', 9]
            ]
        }, {
        	id: 'paneer',
            data: [ 
            	['Paneer Masala', 5],
            	['Paneer Chilli', 2],
            	['Paneer Do Pyaja', 1],
            	['Paneer Kadhai', 9]
            ]
        }, {
        	id: 'rasgolla',
            data: [ 
            	['Kolkata Rasgolla', 5],
            	['Kolkata Delhi', 2],
            	['Kolkata Rasgolla1', 1],
            	['Kolkata Rasgolla2', 9]
            ]
        }]
    }
})*/


$( "#dropdown" ).select2({
    theme: "bootstrap"
});
</script>
<!-- Include Required Prerequisites -->
<script type="text/javascript" src="//cdn.jsdelivr.net/jquery/1/jquery.min.js"></script>
<script type="text/javascript" src="//cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
 
<!-- Include Date Range Picker -->
<script type="text/javascript" src="//cdn.jsdelivr.net/bootstrap.daterangepicker/2/daterangepicker.js"></script>
<link rel="stylesheet" type="text/css" href="//cdn.jsdelivr.net/bootstrap.daterangepicker/2/daterangepicker.css" />

<script type="text/javascript">
$(".js-report").on("click", function() {
  	var type = $(this).attr('id');
  	$("#daily").removeClass('active');
  	$("#week").removeClass('active');
  	$("#month").removeClass('active');
  	
  	$(this).addClass('active');
   	getGraphReport(type);
});


/*$('.js-range').daterangepicker(
    {
        locale: {
          format: 'DD/MM/Y'
        },
        showDropdowns: true,
        ranges: {
            'Today': [moment(), moment()],
            'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
            'Last 7 Days': [moment().subtract(6, 'days'), moment()],
            'Last 30 Days': [moment().subtract(29, 'days'), moment()],
            'This Month': [moment().startOf('month'), moment().endOf('month')],
            'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
            'Last 3 Months': [moment().subtract(3, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
        }
    }
);*/

$(document).ready(function() {

  	var start = moment().subtract(29, 'days');
  	var end = moment();

  	function cb(start, end) {

	    $('.js-range').html(start.format('DD/MM/Y') + ' - ' + end.format('DD/MM/Y'));

	}

  	$('.js-range').daterangepicker({
      	locale: {
          format: 'DD/MM/Y'
        },
        showDropdowns: true,
        startDate: start,
      	endDate: end,
      	ranges: {
         	'Today': [moment(), moment()],
         	'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
         	'Last 7 Days': [moment().subtract(6, 'days'), moment()],
         	'Last 30 Days': [moment().subtract(29, 'days'), moment()],
         	'This Month': [moment().startOf('month'), moment().endOf('month')],
         	'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
         	'Last 3 Months': [moment().subtract(3, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
      	}
  	}, cb);

  	cb(start, end);

});


/*Highcharts.chart('productTrends', {

    title: {
        text: ''
    },

    subtitle: {
        text: ''
    },

    yAxis: {
        title: {
            text: 'Number of orders'
        }
    },
    legend: {
        layout: 'vertical',
        align: 'right',
        verticalAlign: 'middle'
    },

    plotOptions: {
        series: {
            label: {
                connectorAllowed: false
            },
            pointStart: 17
        }
    },

    series: [{
        name: 'repeatOrders',
        data: [10, 0]
    }],

    responsive: {
        rules: [{
            condition: {
                maxWidth: 500
            },
            chartOptions: {
                legend: {
                    layout: 'horizontal',
                    align: 'center',
                    verticalAlign: 'bottom'
                }
            }
        }]
    }

});*/
Highcharts.chart('magquadrant', {
    chart: {
        type: 'scatter',
        zoomType: 'xy'
    },
    title: {
        text: ''
    },
    subtitle: {
        text: ''
    },
    xAxis: {
        title: {
            enabled: true,
            text: 'Total Orders'
        },
        startOnTick: true,
        endOnTick: true,
        showLastLabel: true
    },
    yAxis: {
        title: {
            text: 'Repeat Orders'
        }
    },
    /*legend: {
        layout: 'vertical',
        align: 'left',
        verticalAlign: 'top',
        x: 100,
        y: 70,
        floating: true,
        backgroundColor: (Highcharts.theme && Highcharts.theme.legendBackgroundColor) || '#FFFFFF',
        borderWidth: 1
    },*/
    plotOptions: {
        scatter: {
            marker: {
                radius: 5,
                states: {
                    hover: {
                        enabled: true,
                        lineColor: 'rgb(100,100,100)'
                    }
                }
            },
            states: {
                hover: {
                    marker: {
                        enabled: false
                    }
                }
            },
            tooltip: {
                headerFormat: '<b>{series.name}</b><br>',
                pointFormat: '{point.x}, {point.y}'
            }
        }
    },
    series: [{
        name: 'Products',
        color: 'rgba(223, 83, 83, .5)',
        data: [[161.2, 51.6], [167.5, 59.0], [159.5, 49.2], [157.0, 63.0], [155.8, 53.6],
            [170.0, 59.0], [159.1, 47.6], [166.0, 69.8], [176.2, 66.8], [160.2, 75.2],
            [172.5, 55.2], [170.9, 54.2], [172.9, 62.5], [153.4, 42.0], [160.0, 50.0],
            [147.2, 49.8], [168.2, 49.2], [175.0, 73.2], [157.0, 47.8], [167.6, 68.8],
            [159.5, 50.6], [175.0, 82.5], [166.8, 57.2], [176.5, 87.8], [170.2, 72.8],
            [174.0, 54.5], [173.0, 59.8], [179.9, 67.3], [170.5, 67.8], [160.0, 47.0],
            [154.4, 46.2], [162.0, 55.0], [176.5, 83.0], [160.0, 54.4], [152.0, 45.8],
            [162.1, 53.6], [170.0, 73.2], [160.2, 52.1], [161.3, 67.9], [166.4, 56.6],
            [168.9, 62.3], [163.8, 58.5], [167.6, 54.5], [160.0, 50.2], [161.3, 60.3],
            [167.6, 58.3], [165.1, 56.2], [160.0, 50.2], [170.0, 72.9], [157.5, 59.8],
            [167.6, 61.0], [160.7, 69.1], [163.2, 55.9], [152.4, 46.5], [157.5, 54.3],
            [168.3, 54.8], [180.3, 60.7], [165.5, 60.0], [165.0, 62.0], [164.5, 60.3],
            [156.0, 52.7], [160.0, 74.3], [163.0, 62.0], [165.7, 73.1], [161.0, 80.0],
            [162.0, 54.7], [166.0, 53.2], [174.0, 75.7], [172.7, 61.1], [167.6, 55.7],
            [151.1, 48.7], [164.5, 52.3], [163.5, 50.0], [152.0, 59.3], [169.0, 62.5],
            [164.0, 55.7], [161.2, 54.8], [155.0, 45.9], [170.0, 70.6], [176.2, 67.2],
            [170.0, 69.4], [162.5, 58.2], [170.3, 64.8], [164.1, 71.6], [169.5, 52.8],
            [163.2, 59.8], [154.5, 49.0], [159.8, 50.0], [173.2, 69.2], [170.0, 55.9],
            [161.4, 63.4], [169.0, 58.2], [166.2, 58.6], [159.4, 45.7], [162.5, 52.2],
            [159.0, 48.6], [162.8, 57.8], [159.0, 55.6], [179.8, 66.8], [162.9, 59.4],
            [161.0, 53.6], [151.1, 73.2], [168.2, 53.4], [168.9, 69.0], [173.2, 58.4],
            [171.8, 56.2], [178.0, 70.6], [164.3, 59.8], [163.0, 72.0], [168.5, 65.2],
            [166.8, 56.6], [172.7, 105.2], [163.5, 51.8], [169.4, 63.4], [167.8, 59.0],
            [159.5, 47.6], [167.6, 63.0], [161.2, 55.2], [160.0, 45.0], [163.2, 54.0],
            [162.2, 50.2], [161.3, 60.2], [149.5, 44.8], [157.5, 58.8], [163.2, 56.4],
            [172.7, 62.0], [155.0, 49.2], [156.5, 67.2], [164.0, 53.8], [160.9, 54.4],
            [162.8, 58.0], [167.0, 59.8], [160.0, 54.8], [160.0, 43.2], [168.9, 60.5],
            [158.2, 46.4], [156.0, 64.4], [160.0, 48.8], [167.1, 62.2], [158.0, 55.5],
            [167.6, 57.8], [156.0, 54.6], [162.1, 59.2], [173.4, 52.7], [159.8, 53.2],
            [170.5, 64.5], [159.2, 51.8], [157.5, 56.0], [161.3, 63.6], [162.6, 63.2],
            [160.0, 59.5], [168.9, 56.8], [165.1, 64.1], [162.6, 50.0], [165.1, 72.3],
            [166.4, 55.0], [160.0, 55.9], [152.4, 60.4], [170.2, 69.1], [162.6, 84.5],
            [170.2, 55.9], [158.8, 55.5], [172.7, 69.5], [167.6, 76.4], [162.6, 61.4],
            [167.6, 65.9], [156.2, 58.6], [175.2, 66.8], [172.1, 56.6], [162.6, 58.6],
            [160.0, 55.9], [165.1, 59.1], [182.9, 81.8], [166.4, 70.7], [165.1, 56.8],
            [177.8, 60.0], [165.1, 58.2], [175.3, 72.7], [154.9, 54.1], [158.8, 49.1],
            [172.7, 75.9], [168.9, 55.0], [161.3, 57.3], [167.6, 55.0], [165.1, 65.5],
            [175.3, 65.5], [157.5, 48.6], [163.8, 58.6], [167.6, 63.6], [165.1, 55.2],
            [165.1, 62.7], [168.9, 56.6], [162.6, 53.9], [164.5, 63.2], [176.5, 73.6],
            [168.9, 62.0], [175.3, 63.6], [159.4, 53.2], [160.0, 53.4], [170.2, 55.0],
            [162.6, 70.5], [167.6, 54.5], [162.6, 54.5], [160.7, 55.9], [160.0, 59.0],
            [157.5, 63.6], [162.6, 54.5], [152.4, 47.3], [170.2, 67.7], [165.1, 80.9],
            [172.7, 70.5], [165.1, 60.9], [170.2, 63.6], [170.2, 54.5], [170.2, 59.1],
            [161.3, 70.5], [167.6, 52.7], [167.6, 62.7], [165.1, 86.3], [162.6, 66.4],
            [152.4, 67.3], [168.9, 63.0], [170.2, 73.6], [175.2, 62.3], [175.2, 57.7],
            [160.0, 55.4], [165.1, 104.1], [174.0, 55.5], [170.2, 77.3], [160.0, 80.5],
            [167.6, 64.5], [167.6, 72.3], [167.6, 61.4], [154.9, 58.2], [162.6, 81.8],
            [175.3, 63.6], [171.4, 53.4], [157.5, 54.5], [165.1, 53.6], [160.0, 60.0],
            [174.0, 73.6], [162.6, 61.4], [174.0, 55.5], [162.6, 63.6], [161.3, 60.9],
            [156.2, 60.0], [149.9, 46.8], [169.5, 57.3], [160.0, 64.1], [175.3, 63.6],
            [169.5, 67.3], [160.0, 75.5], [172.7, 68.2], [162.6, 61.4], [157.5, 76.8],
            [176.5, 71.8], [164.4, 55.5], [160.7, 48.6], [174.0, 66.4], [163.8, 67.3]]

    }]
});
</script>