<?php
session_start();
if(!isset($_SESSION['user'])) {
	header("location: ../index.php");
	exit;
}

include "../dbconnect.php";
 
include"../header.php";

?>
<link href="../assets/css/analysis.css" rel="stylesheet">
						<div class="row">
							<div class="col-lg-12">

								<div class="card">
									<div class="card-header admin-feed">
										Order Insights
									</div>
									<div class="card-body">
										<div class="row">
											<div class="col-lg-12">
												<section style="min-height: 467px;">
												   	<!-- START Page content-->
												   	<div class="content-wrapper" style="overflow: initial;">

												     	<h4 class="mt-lg mb-lg heading-sub-menu">
												            <span class="btn-group pull-right">
												          		<button type="button" class="btn text-md btn-menu dropdown-toggle pull-right js-range" data-toggle="dropdown" aria-expanded="false">March 15, 2018 to March 22, 2018<span class="caret"></span></button>
												        	</span>
												            <span class="text-xl">Acquistion Channel Insights</span>
												     	</h4>

												    	<ul class="nav nav-tabs nav-pills mb pl heading-border">
													        <li class="active ml">
													        	<a href="#channel-orders" class="js-channel-orders"  data-toggle="tab">Orders</a>
													        </li>
													        <li>
													        	<a href="#channel-profitability" class="js-channel-repeat-rate"  data-toggle="tab">Profitability</a>
													        </li>
													        <li>
													        	<a href="#channel-shifting" class="js-channel-shifting" data-toggle="tab">Shifting</a>
													        </li>
													        <li>
													        	<a href="#channel-overtime" class="js-channel-overtime" data-toggle="tab">Overtime</a>
													        </li>
													    </ul>

													    <div class="tab-content">
													    	<!-- start order tab -->
													      	<div id="channel-orders" class="tab-pane fade in active tab-custom" role="tabpanel">

													      		<div class="analytic-numbers mt-xl ml">
														      		<div class="row">
															         	<div class="col-md-6">
															            	
															                <div class="panel panel-success text-success">
															                  	<div class="panel-body">
															                     	<div class="row">
																                        <div class="col-xs-3">
																                           	<em class="fa fa-group fa-5x"></em>
																                        </div>
																                        <div class="col-xs-9 text-right">
																                           	<div class="text-xl">2</div>
																                           	<p class="m0">New Customers</p>
																                        </div>
															                     	</div>
															                  	</div>
															               	</div>
															            	
															         	</div>
																        <div class="col-md-6">
																            
															               	<div class="panel panel-primary text-primary">
															                  	<div class="panel-body">
															                    	<div class="row">
																                        <div class="col-xs-3">
																                           	<em class="fa fa-shopping-bag fa-5x"></em>
																                        </div>
																                        <div class="col-xs-9 text-right">
																                           	<div class="text-xl">0</div>
																                           	<p class="m0">Repeat Orders</p>
																                        </div>
																                    </div>
															                  	</div>
															               	</div>
																            
																        </div>
															      	</div>
															  	</div>

															  	<p class="text-lg ml-lg fw400 mt-xl">Track channel performance.</p>
														      	<p class="text-md ml-lg fw300">See new vs. repeat orders across channels.</p>

														      	<div class="graphbox mt-xl">
														        	<div class="js-graph-channelanalytics" style="">
														          		<div class="channelanalytics" id="container" style="width: 1200px; height: 400px; margin: 0 auto" data-highcharts-chart="0">
														          			
														          		</div>
														        	</div>
															        <div class="js-load-channelanalytics" align="center" style="display: none;">
															          	<div class="loader graph-load"></div>
															        </div>
															        <!-- <p class="mt text-center">
															        	<a href="https://xenohq.typeform.com/to/nAUpRI">Data seems inaccurate? Report it here.</a>
															        </p> -->
														      	</div>

													      	</div>

													      	<!-- start profitability tab -->
													      	<div id="channel-profitability" class="tab-pane fade in tab-custom" role="tabpanel">
													      		<p class="text-lg ml-lg fw400 mt-xl">Which channel is the most profitable?</p>
	                                                            <p class="text-md ml-lg fw300">Track retention rate &amp; order value across channels.</p>

	                                                            <div class="js-load-4 text-center" style="display: none;">
	                                                              	<div class="loader graph-load"></div>
	                                                            </div>

	                                                            <div class="table-responsive ml-lg text-lg" id="table-repeat-orders-panel">
	                                                               	<table class="table table-hover table-striped">
	                                                                  	<thead>
	                                                                     	<tr>
	                                                                        	<th class="fw400"><span class="text-gray-dark">Channel</span></th>
	                                                                        	<th class="fw400">
	                                                                          		<a href="javascript:void(0);" title="" data-toggle="tooltip" class="text-gray-dark" data-original-title="No. of new customers">Customers Acquired</a>
	                                                                        	</th>
	                                                                        	<th class="fw400">
	                                                                          		<a href="javascript:void(0);" title="" data-toggle="tooltip" class="text-gray-dark" data-original-title="% of customers who placed at-least their 2nd order">Repeat Rate</a>
	                                                                        	</th>
	                                                                        	<th class="fw400">
	                                                                        		<a href="javascript:void(0);" title="" data-toggle="tooltip" class="text-gray-dark" data-original-title="Avg. spend per order from a channel">Spend/ Order</a>
	                                                                        	</th>
	                                                                     	</tr>
	                                                                  	</thead>
	                                                                  	<tbody class="table-repeat-orders">
	                                                                  		
	                                                                  	</tbody>
	                                                               	</table>
	                                                            </div>
													      	</div>

													      	<!-- start shifting tab -->
													      	<div id="channel-shifting" class="tab-pane fade in tab-custom" role="tabpanel">
													      		<p class="text-lg ml-lg fw400 mt-xl">Do customers switch ordering channels?</p>
														      	<p class="text-md ml-lg fw300">Select a channel to find out.</p>
														      	<span class="btn-group ml-lg">
														        	<button type="button" class="btn btn-menu dropdown-toggle pull-right text-md" data-toggle="dropdown" aria-expanded="false">
														          	<span class="js-channel-shift-value">Outlet</span>
														          	<span class="caret"></span>
														        	</button>
														        	<ul class="dropdown-menu" role="menu">
														                <li class="js-change-channel-shift"><a href="javascript:void(0);">Outlet</a></li>
														            </ul>
														      	</span>

														       	<div class="graphbox">
														        	<div class="js-graph-channelshift" style="">
														          		<div class="channelshift" id="channelshift" style="width: 1200px; height: 400px; margin: 0 auto" data-highcharts-chart="0">
														          		</div>
														        	</div>
														        	<div class="js-load-channelshift" align="center" style="display: none;">
														          		<div class="loader graph-load"></div>
														        	</div>
														      	</div>
													      	</div>

													      	<!-- start overtime tab -->
													      	<div id="channel-overtime" class="tab-pane fade in tab-custom" role="tabpanel">
													      		<p class="text-lg ml-lg fw400 mt-xl">How do orders change for a channel over-time?</p>
	                                                          	<p class="text-md ml-lg fw300">Select a channel to find out.</p>
	                                                          	<span class="btn-group ml-lg">
	                                                            	<button type="button" class="btn btn-menu dropdown-toggle pull-right text-md" data-toggle="dropdown" aria-expanded="false">
	                                                              		<span class="js-channel-value">Outlet</span>
	                                                              		<span class="caret"></span>
	                                                            	</button>
	                                                            	<ul class="dropdown-menu" role="menu">
                                                                        <li class="js-change-channel-time"><a href="javascript:void(0);">Outlet</a></li>
                                                                    </ul>
	                                                          	</span>
	                                                          	<div class="btn-group ml">
	                                                              	<button type="button" class="btn btn-default js-graph-change js-report text-md active" id="daily">Daily</button>
	                                                              	<button type="button" class="btn btn-default js-graph-change js-report text-md" id="weekly" active="">Weekly</button>
	                                                              	<button type="button" class="btn btn-default js-graph-change js-report text-md" id="month">Monthly</button>
	                                                          	</div>

	                                                          	<div class="graphbox">
	                                                            	<div class="js-graph-overtime mt-xl" style="">
	                                                              		<div class="overtime" id="overtime" style="width: 1200px; height: 400px; margin: 0 auto" data-highcharts-chart="1">
	                                                              			
	                                                              		</div>
	                                                            	</div>
		                                                            <div class="js-load-overtime" align="center" style="display: none;">
		                                                              	<div class="loader graph-load"></div>
		                                                            </div>
	                                                          	</div>
													      	</div>

													    </div>

												   </div>
												   <!-- END Page content-->
												</section>
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
<?php
include"../footer.php";
?>

<!-- Include Required Prerequisites -->
<script type="text/javascript" src="//cdn.jsdelivr.net/jquery/1/jquery.min.js"></script>
<script type="text/javascript" src="//cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
 
<!-- Include Date Range Picker -->
<script type="text/javascript" src="//cdn.jsdelivr.net/bootstrap.daterangepicker/2/daterangepicker.js"></script>
<link rel="stylesheet" type="text/css" href="//cdn.jsdelivr.net/bootstrap.daterangepicker/2/daterangepicker.css" />

<script type="text/javascript">
/*var start_date,end_date,business_id=0;


$(".js-channel-orders").on("click", function() {
  	window.location = "report/channel-orders?startDate="+start_date+"&endDate="+end_date;
});

$(".js-channel-repeat-rate").on("click", function() {
  	window.location = "report/channel-repeat-rate?startDate="+start_date+"&endDate="+end_date;
});

$(".js-channel-shifting").on("click", function() {
    window.location = "report/channel-shifting?startDate="+start_date+"&endDate="+end_date;
});

$(".js-channel-overtime").on("click", function() {
  	window.location = "report/channel-overtime?startDate="+start_date+"&endDate="+end_date;
});*/


$(document).ready(function(){
  // $('.weeklyorder').css("background-color", "#C0C0C0");
  // $('.weeklyrevenue').css("background-color", "#C0C0C0");
  // loadvisitgraph('weekly');
  // loadrevenuegraph('weekly');


  // var start = moment().subtract(7, 'days');
  // var end = moment();
  // start_date=start.format('YYYY-MM-DD');
  // end_date=end.format('YYYY-MM-DD');
  // console.log(start_date);

  if('1'){
    start = moment('2018-03-16');
    end = moment('2018-03-23');

  }else{
    start = moment().subtract(7, 'days');
    end = moment();
   
  }
  start_date=start.format('YYYY-MM-DD');
  end_date=end.format('YYYY-MM-DD');

  function cb(start, end) {

    $('#reportrange span').html(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'));
    start_date=start.format('YYYY-MM-DD');
    end_date=end.format('YYYY-MM-DD');

    $('.js-range').html(start.format('MMMM D, YYYY') + ' to ' + end.format('MMMM D, YYYY')+"<span class=\"caret\">");
    channelAnalyticsNumbers();
    loadChannelRepeatOrders();

  }

  $('.js-range').daterangepicker({
      startDate: start,
      endDate: end,
      ranges: {
         'Today': [moment(), moment()],
         'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
         'Last 7 Days': [moment().subtract(6, 'days'), moment()],
         'Last 30 Days': [moment().subtract(29, 'days'), moment()],
         'This Month': [moment().startOf('month'), moment().endOf('month')],
         'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
         'Last 3 Months': [moment().subtract(3, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
      }
  }, cb);

  cb(start, end);


});

Highcharts.chart('container', {
    chart: {
        type: 'column'
    },
    title: {
        text: ''
    },
    subtitle: {
        text: ''
    },
    xAxis: {
        type: 'category'
    },
    yAxis: {
        title: {
            text: 'Count'
        }

    },
    legend: {
        enabled: false
    },
    plotOptions: {
        series: {
            borderWidth: 0,
            dataLabels: {
                enabled: true,
                format: ''
            }
        }
    },

    tooltip: {
        headerFormat: '<span style="font-size:11px">{series.name}</span><br>',
        pointFormat: '<span style="color:{point.color}">{point.name}</span>: <b>{point.y}</b><br/>'
    },

    series: [{
        name: 'Outlet',
        colorByPoint: true,
        data: [{
            name: 'New Customers',
            y: 56,
            drilldown: 'New Customers'
        }]
    }]
});


/*Highcharts.chart('channelshift', {
    chart: {
        type: 'bar'
    },
    title: {
        text: 'Customers Shifting'
    },
    subtitle: {
        text: ''
    },
    xAxis: {
        categories: ['Outlet'],
        title: {
            text: null
        }
    },
    yAxis: {
        min: 0,
        title: {
            text: 'Order Shift',
            align: 'high'
        },
        labels: {
            overflow: 'justify'
        }
    },
    tooltip: {
        valueSuffix: ' '
    },
    plotOptions: {
        bar: {
            dataLabels: {
                enabled: true
            }
        }
    },
    legend: {
        layout: 'vertical',
        align: 'right',
        verticalAlign: 'top',
        x: -40,
        y: 80,
        floating: true,
        borderWidth: 1,
        backgroundColor: ((Highcharts.theme && Highcharts.theme.legendBackgroundColor) || '#FFFFFF'),
        shadow: true
    },
    credits: {
        enabled: false
    },
    series: [{
        name: 'Customers shifted',
        data: [38]
    }]
});*/


Highcharts.chart('overtime', {

    title: {
        text: ''
    },

    subtitle: {
        text: ''
    },

    yAxis: {
        title: {
            text: 'Number of orders'
        }
    },
    legend: {
        layout: 'vertical',
        align: 'right',
        verticalAlign: 'middle'
    },

    plotOptions: {
        series: {
            label: {
                connectorAllowed: false
            },
            pointStart: 17
        }
    },

    series: [{
        name: 'repeatOrders',
        data: [0, 0, 0, 0, 0, 0, 10, 0]
    }],

    responsive: {
        rules: [{
            condition: {
                maxWidth: 500
            },
            chartOptions: {
                legend: {
                    layout: 'horizontal',
                    align: 'center',
                    verticalAlign: 'bottom'
                }
            }
        }]
    }

});


$(".js-report").on("click", function() {
	var type = $(this).attr('id');
	$("#daily").removeClass('active');
	$("#Weekly").removeClass('active');
	$("#month").removeClass('active');

	if(type=="daily"){
		$(this).addClass('active');
	}else if(type=="Weekly"){
		$(this).addClass('active');
	}else if(type=="month"){
		$(this).addClass('active');
	}else{

	}

});
</script>